
rm(list = ls())
library(readxl)
library(dplyr)
library(plyr)
library(lubridate)
library(xtable)
library(ivreg)
library(texreg)
library(car)
library(nleqslv)
library(readxl)
options(scipen=999)

inpath  <- ''

file <- paste0(inpath, 'Base servicios móviles.csv')
base_mercado <- read.csv(file = file, sep = ',')

base_mercado$t <- 3*(base_mercado$TRIMESTRE - 1) + base_mercado$MES_DEL_TRIMESTRE
base_mercado$t[base_mercado$t < 10] <- paste0('0', base_mercado$t[base_mercado$t < 10])
base_mercado$t <- paste(base_mercado$ANNO, base_mercado$t, sep = '-')
base_mercado$SEMESTRE <- ifelse(base_mercado$TRIMESTRE<3,1,2)

d <- base_mercado

d   <- ddply(d, .(ANNO, SEMESTRE, TRIMESTRE, MES, t, NOM_COMERCIAL, SERVICIO_PAQUETE), summarize,
             q = sum(lineas),
             vp = sum(valor_facturado))
d <- d %>% filter(!is.na(q), !is.na(vp))
d   <- ddply(d, .(t, SERVICIO_PAQUETE), mutate, M = sum(q))
d   <- d[d$q > 0 & d$vp > 0, ]
d$s <- d$q/d$M
do  <- d

d$j <- as.numeric(as.factor(paste(d$NOM_COMERCIAL, d$SERVICIO_PAQUETE, sep = '-')))

d$p <- d$vp/d$q

d <- d %>% left_join(base_mercado %>% select(ANNO, SEMESTRE, TRIMESTRE, MES, t, NOM_COMERCIAL, SERVICIO_PAQUETE, precio_fijos_mes, nsu))

x  <- ddply(d[d$SERVICIO_PAQUETE == 'Voz móvil + internet móvil', ], .(t, NOM_COMERCIAL), summarize, v = sum(s)*100, m = mean(M))
x  <- ddply(x, .(NOM_COMERCIAL), summarize, m = round(weighted.mean(v, w = m), 4))
f  <- x$NOM_COMERCIAL[x$m >= 4]
d2 <- d[d$NOM_COMERCIAL %in% f & d$SERVICIO_PAQUETE == 'Voz móvil + internet móvil', ]
controles_d2 <- base_mercado %>%
  select(ANNO, t, NOM_COMERCIAL, SERVICIO_PAQUETE, pospago, banda_ancha, accesos_4G, accesos_5G, traf_int_pos, ing_gb, gb_acceso, ing_min, traf_voz_posp, facturado_pos, ing_acceso, precio_int_fijo, precio_fijos, precio_int_fijo_mes, precio_fijos_mes)

d2 <- d2 %>%
  left_join(controles_d2)

DATA <- d2

DATA <- ddply(DATA, .(t), mutate, so = 1 - sum(s))
DATA$delta <- log(DATA$s) - log(DATA$so)

m6 <- ivreg(delta ~ p + NOM_COMERCIAL + pospago + banda_ancha + ing_gb + ing_min| precio_fijos + precio_int_fijo + NOM_COMERCIAL + pospago + banda_ancha + ing_gb + ing_min, data = DATA)
summary(m6)

empresa <- c("Tigo", "Movistar", "Comcel", "WOM")

observado <- DATA %>%
  filter(t==max(t)) %>%
  mutate(orden = ifelse(NOM_COMERCIAL=="Tigo", 1,
                        ifelse(NOM_COMERCIAL=="Movistar", 2,
                               ifelse(NOM_COMERCIAL=="Claro",3,NA)))) %>%
  arrange(orden) %>%
  mutate(int = 1, t = 1,
         d_Tigo = ifelse(NOM_COMERCIAL=="Tigo",1,0),
         d_Movistar = ifelse(NOM_COMERCIAL=="Movistar",1,0),
         d_WOM = ifelse(NOM_COMERCIAL=="WOM",1,0))

n_obs<- as.numeric(nrow(observado))

caracteristicas_obs <- as.matrix(select(observado, pospago, banda_ancha, ing_gb, ing_min, int, d_Tigo, d_Movistar, d_WOM))
precios_obs <- as.matrix(select(observado, p))
participaciones_obs <- as.matrix(select(observado, s))

caracteristicas_integracion <- caracteristicas_obs
caracteristicas_integracion[1,1] <- caracteristicas_obs[2,1]
caracteristicas_integracion[1,2] <- (caracteristicas_obs[1,2]+caracteristicas_obs[2,2])/2
caracteristicas_integracion[2,2] <- (caracteristicas_obs[1,2]+caracteristicas_obs[2,2])/2
caracteristicas_integracion[1,3] <- caracteristicas_obs[2,3]
caracteristicas_integracion[2,4] <- caracteristicas_obs[1,4]
caracteristicas_integracion[2,6] <- 1
caracteristicas_integracion[2,7] <- 0

alpha_est <- 0.2028

beta_est <- c(-3.5417, -3.8247, 0.2442, 2.3521, 14.2017, -2.4059, -2.5793, -3.5935)

f_elasticidades <- function(alpha, sharesobs, precios){
  N <- as.numeric(nrow(precios))
  r_elasticidad <- matrix(data=NA, ncol=N, nrow=N)
  for(i in 1:N){
    for(j in 1:N){
      r_elasticidad[i,j] <- (alpha*precios[j])*sharesobs[j]
    }
  }
  diag(r_elasticidad) <- -alpha*precios*(1-sharesobs)
  return(r_elasticidad)
}

f_costosm_equilibrio <- function(elasticidades, precios){
  N <- as.numeric(nrow(precios))
  r_costos <- (1+1/diag(elasticidades))*precios
  colnames(r_costos) <- c("Costos estimados")
  return(r_costos)
}

f_participaciones_est <- function(alpha, beta, caracteristicas, precios){
  N <- as.numeric(nrow(precios))
  V <- matrix(data=NA, ncol=1, nrow=N)
  for(j in 1:N){
    V[j,1] <- exp(as.numeric(caracteristicas[j,]%*%beta)-as.numeric(alpha*precios[j,1]))
  }
  r_participaciones <- matrix(data=NA, ncol=1, nrow=N)
  denominador <- 1+sum(V)
  r_participaciones <- (1/denominador)*V
  return(r_participaciones)
}

f_condiciones_eq <- function(input){
  N <- n_obs
  precios_input <- input[1:N]
  participaciones_input <- input[(N+1):(2*N)]
  c_integradas <- c()
  c_integradas[1] <- 1+((precios_input[1]-as.numeric(costos_est[1,1])))*(-alpha_est*(1-participaciones_input[1]))+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])
  c_integradas[2] <-1+((precios_input[2]-as.numeric(costos_est[2,1])))*(-alpha_est*(1-participaciones_input[2]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])
  c_competidores <- costos_est-precios_input*(1-1/(alpha_est*(1-participaciones_input)*precios_input))
  c_competidores <- c_competidores[-c(1:2),]
  c_participaciones <- participaciones_input-f_participaciones_est(alpha=alpha_est,
                                                                   beta=beta_est,
                                                                   caracteristicas = caracteristicas_integracion,
                                                                   precios=as.matrix(precios_input))

  ajuste <- rbind(as.matrix(c_integradas),as.matrix(c_competidores), as.matrix(c_participaciones))
  return(ajuste)
}

f_condiciones_eq_coordinado <- function(input){
  N <- n_obs
  precios_input <- input[1:N]
  participaciones_input <- input[(N+1):(2*N)]
  c_integradas <- c()
  c_integradas[1] <- 1+((precios_input[1]-as.numeric(costos_est[1,1])))*(-alpha_est*(1-participaciones_input[1]))+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])+
    (precios_input[3]-as.numeric(costos_est[3,1]))*(alpha_est*participaciones_input[3])
  c_integradas[2] <-1+((precios_input[2]-as.numeric(costos_est[2,1])))*(-alpha_est*(1-participaciones_input[2]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])+
    (precios_input[3]-as.numeric(costos_est[3,1]))*(alpha_est*participaciones_input[3])
  c_integradas[3] <-1+((precios_input[3]-as.numeric(costos_est[3,1])))*(-alpha_est*(1-participaciones_input[3]))+
    (precios_input[1]-as.numeric(costos_est[1,1]))*(alpha_est*participaciones_input[1])+
    (precios_input[2]-as.numeric(costos_est[2,1]))*(alpha_est*participaciones_input[2])
  c_competidores <- costos_est-precios_input*(1-1/(alpha_est*(1-participaciones_input)*precios_input))
  c_competidores <- c_competidores[-c(1:3),]
  c_participaciones <- participaciones_input-f_participaciones_est(alpha=alpha_est,
                                                                   beta=beta_est,
                                                                   caracteristicas = caracteristicas_integracion,
                                                                   precios=as.matrix(precios_input))

  ajuste <- rbind(as.matrix(c_integradas),as.matrix(c_competidores), as.matrix(c_participaciones))
  return(ajuste)
}

f_beneficios <- function(precios, costos, shares){
  beneficios <- (precios-costos)*shares
  colnames(beneficios) <- c("Beneficios")
  return(beneficios)
}

precio_mercado_obs <- as.numeric(precios_obs[,1]%*%participaciones_obs[,1])
precio_mercado_obs

elas_est<- f_elasticidades(alpha=alpha_est, sharesobs=participaciones_obs, precios=precios_obs)
elas_est

participaciones_est <- f_participaciones_est(alpha=alpha_est, beta=beta_est, caracteristicas = caracteristicas_obs, precios=precios_obs)
participaciones_est

costos_est <- f_costosm_equilibrio(elasticidades = elas_est, precios=precios_obs)
rownames(costos_est) <- empresa
costos_est

beneficios_obs <- f_beneficios(precios=precios_obs,
                               costos = costos_est,
                               shares = participaciones_obs)

beneficios_obs

costo_eficiencia <- costos_est

coef_eficiencia <- 0.9004

coef_sinergia <- observado$s[1]/(observado$s[1]+observado$s[2])

costo_eficiencia[c(1,2),] <-coef_eficiencia*(coef_sinergia*costo_eficiencia[1,]+(1-coef_sinergia)*costo_eficiencia[2,])
costos_est <- costo_eficiencia
costos_est

condiciones_iniciales <- rbind(precios_obs, participaciones_obs)
condiciones_iniciales

equilibrio <-  nleqslv(x=condiciones_iniciales, fn=f_condiciones_eq, control = list(maxit = 1500))
equilibrio

equilibrio$x
sum(equilibrio$x[5:8])

precios_integracion <- equilibrio$x[1:n_obs]
precios_integracion

participaciones_integracion <- equilibrio$x[(n_obs+1):(2*n_obs)]
participaciones_integracion

precio_mercado_integracion <- as.numeric(precios_integracion%*%participaciones_integracion)
precio_mercado_integracion

beneficios_integracion <- f_beneficios(precios=precios_integracion,
                                       costos=costos_est,
                                       shares=participaciones_integracion)
beneficios_integracion

equilibrio_coordinado <-  nleqslv(x=condiciones_iniciales, fn=f_condiciones_eq_coordinado)
equilibrio_coordinado
equilibrio_coordinado$x
sum(equilibrio_coordinado$x[5:8])

precios_colusion <- equilibrio_coordinado$x[1:n_obs]
precios_colusion

participaciones_colusion <- equilibrio_coordinado$x[(n_obs+1):(2*n_obs)]
participaciones_colusion

precio_mercado_colusion <- as.numeric(precios_colusion%*%participaciones_colusion)
precio_mercado_colusion

beneficios_colusion <- f_beneficios(precios=precios_colusion,
                                    costos=costos_est,
                                    shares=participaciones_colusion)

precios_traicion <- precios_colusion
precios_traicion[1:2] <- precios_integracion[1:2]
participaciones_traicion <- f_participaciones_est(alpha=alpha_est,
                                                  beta=beta_est,
                                                  caracteristicas = caracteristicas_integracion,
                                                  precios=as.matrix(precios_traicion))

precio_mercado_traicion <- as.numeric(precios_traicion%*%participaciones_traicion)
precio_mercado_traicion

beneficios_traicion <- f_beneficios(precios=precios_traicion,
                                    costos=costos_est,
                                    shares=participaciones_traicion)

escenarios <- c("Observado","Integración", "Colusión", "Traición")

resumen_participaciones <- cbind(participaciones_est,
                                 participaciones_integracion,
                                 participaciones_colusion,
                                 participaciones_traicion)
colnames(resumen_participaciones) <- escenarios
rownames(resumen_participaciones) <- empresa
resumen_participaciones

resumen_beneficios <- cbind(beneficios_obs,
                            beneficios_integracion,
                            beneficios_colusion,
                            beneficios_traicion)
colnames(resumen_beneficios) <- escenarios
rownames(resumen_beneficios) <- empresa
resumen_beneficios

resumen_precios <- cbind(precios_obs,
                         precios_integracion,
                         precios_colusion,
                         precios_traicion)
colnames(resumen_precios) <- escenarios
rownames(resumen_precios) <- empresa
resumen_precios

resumen_precio_mercado <- cbind(precio_mercado_obs,
                                precio_mercado_integracion,
                                precio_mercado_colusion,
                                precio_mercado_traicion)
colnames(resumen_precio_mercado) <- escenarios
resumen_precio_mercado

delta_integrada <- (beneficios_traicion[1]-beneficios_colusion[1])/(beneficios_traicion[1]-beneficios_integracion[1])
delta_integrada

precios_traicion_2 <- precios_colusion
precios_traicion_2[3] <- precios_integracion[3]
participaciones_traicion_2 <- f_participaciones_est(alpha=alpha_est,
                                                    beta=beta_est,
                                                    caracteristicas = caracteristicas_integracion,
                                                    precios=as.matrix(precios_traicion_2))
participaciones_traicion_2

precio_mercado_traicion_2 <- as.numeric(precios_traicion_2%*%participaciones_traicion_2)

beneficios_traicion_2 <- f_beneficios(precios=precios_traicion_2, costos=costos_est, shares=participaciones_traicion_2)
beneficios_traicion_2

delta_lider <- (beneficios_traicion_2[3]-beneficios_colusion[3])/(beneficios_traicion_2[3]-beneficios_integracion[3])
delta_lider

impacto_precio_integracion <- (precio_mercado_integracion/precio_mercado_obs-1)*100
impacto_precio_integracion
impacto_precio_colusion <- (precio_mercado_colusion/precio_mercado_obs-1)*100
impacto_precio_colusion
impacto_precio_traicion <- (precio_mercado_traicion/precio_mercado_obs-1)*100
impacto_precio_traicion

resumen_impacto_precio <- cbind(impacto_precio_integracion,
                                impacto_precio_colusion,
                                impacto_precio_traicion)
colnames(resumen_impacto_precio) <- escenarios[-1]
resumen_impacto_precio

utilidad_obs <- participaciones_obs[,1] %*% (caracteristicas_obs%*%beta_est-alpha_est*precios_obs)
utilidad_obs
utilidad_integracion <- participaciones_integracion %*% (caracteristicas_integracion%*%beta_est-alpha_est*precios_integracion)
utilidad_integracion
utilidad_colusion <- participaciones_colusion %*% (caracteristicas_integracion%*%beta_est-alpha_est*precios_colusion)
utilidad_colusion

impacto_bienestar_integracion <- ((utilidad_integracion/utilidad_obs)-1)*100
impacto_bienestar_colusion <- ((utilidad_colusion/utilidad_obs)-1)*100

resumen_bienestar <- cbind(impacto_bienestar_integracion,impacto_bienestar_colusion)
colnames(resumen_bienestar) <- escenarios[-c(1,4)]
resumen_bienestar
